/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class StarFallParticle
extends TextureSheetParticle {
    private final Vec3 origin;
    private final float speed;
    private final float maxRadius;
    private final float currentRadius;

    public StarFallParticle(ClientLevel pLevel, double pX, double pY, double pZ, int alpha, int color, float speed, float size, float maxRadius, Vec3 origin) {
        super(pLevel, pX, pY, pZ);
        this.f_107225_ = 80;
        float r = color >> 16 & 0xFF;
        float g = color >> 8 & 0xFF;
        float b = color & 0xFF;
        this.m_107253_(r / 255.0f, g / 255.0f, b / 255.0f);
        this.f_107219_ = false;
        this.origin = origin;
        this.speed = speed;
        this.maxRadius = maxRadius;
        this.currentRadius = 0.0f;
        this.f_107663_ = size;
        this.f_107230_ = alpha;
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107663_ += 1.0f;
    }

    public void m_5744_(@NotNull VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        double interpolatedX = Mth.m_14139_((double)pPartialTicks, (double)this.f_107209_, (double)this.f_107212_);
        double interpolatedY = Mth.m_14139_((double)pPartialTicks, (double)this.f_107210_, (double)this.f_107213_);
        double interpolatedZ = Mth.m_14139_((double)pPartialTicks, (double)this.f_107211_, (double)this.f_107214_);
        Vec3 cameraPos = pRenderInfo.m_90583_();
        float translateX = (float)(interpolatedX - cameraPos.m_7096_());
        float translateY = (float)(interpolatedY - cameraPos.m_7098_());
        float translateZ = (float)(interpolatedZ - cameraPos.m_7094_());
        Quaternion baseRotation = Vector3f.f_122225_.m_122240_(90.0f);
        if (this.f_107231_ != 0.0f) {
            float rollAngle = Mth.m_14179_((float)pPartialTicks, (float)this.f_107204_, (float)this.f_107231_);
            baseRotation.m_80148_(Vector3f.f_122227_.m_122270_(rollAngle));
        }
        float quadSize = this.m_5902_(pPartialTicks);
        Vector3f[] baseVertices = new Vector3f[]{new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(-1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, -1.0f)};
        Vector3f[] transformedVertices = new Vector3f[4];
        for (int i = 0; i < 4; ++i) {
            Vector3f transformed = new Vector3f(baseVertices[i].m_122239_(), baseVertices[i].m_122260_(), baseVertices[i].m_122269_());
            transformed.m_122251_(baseRotation);
            transformed.m_122261_(quadSize);
            transformed.m_122272_(translateX, translateY, translateZ);
            transformedVertices[i] = transformed;
        }
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0 = this.m_5951_();
        float v1 = this.m_5950_();
        int packedLight = this.m_6355_(pPartialTicks);
        this.addVertex(pBuffer, transformedVertices[0], u1, v1, packedLight);
        this.addVertex(pBuffer, transformedVertices[1], u1, v0, packedLight);
        this.addVertex(pBuffer, transformedVertices[2], u0, v0, packedLight);
        this.addVertex(pBuffer, transformedVertices[3], u0, v1, packedLight);
        this.addVertex(pBuffer, transformedVertices[3], u0, v1, packedLight);
        this.addVertex(pBuffer, transformedVertices[2], u0, v0, packedLight);
        this.addVertex(pBuffer, transformedVertices[1], u1, v0, packedLight);
        this.addVertex(pBuffer, transformedVertices[0], u1, v1, packedLight);
    }

    private void addVertex(VertexConsumer buffer, Vector3f pos, float u, float v, int light) {
        buffer.m_5483_((double)pos.m_122239_(), (double)pos.m_122260_(), (double)pos.m_122269_()).m_7421_(u, v).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107432_;
    }

    public Vec3 getOrigin() {
        return this.origin;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getMaxRadius() {
        return this.maxRadius;
    }

    public float getCurrentRadius() {
        return this.currentRadius;
    }
}

